<?php

class serv_Model_DbTable_Programaitem extends Zsam_Db_Table {

	/**
	 * The default table name
	 */

	protected $_name = 'progritens';

	var $_autocomplet = array('ITEM_PROGR','NUM_ITEM','PRODUTO');

	var $_conf = array(
			'CLIENTE' 				=> array('edit' => 'N', 'grid' => true, 'NULLABLE' => false),
			'ITEM_PROGR'			=> array('edit' => 'N'),
			'NUM_ITEM' 				=> array('edit' => 'N', 'grid' => true, 'NULLABLE' => false),
            'ID'					=> array('edit' => 'N'),
			'EMPRESA' 				=> array('edit' => 'N', 'grid' => true, 'NULLABLE' => false),
			'PRODUTO' 				=> array('autocomplete'=>'Y','NULLABLE' => false),
			'DESCRICAO_ITEM_NOVO'	=> array('edit' => 'N'),//nao esta sendo usado seria para cadastrar item novo
	        'CFOP' 					=> array('NULLABLE' => false),
	        'QUANTIDADE' 			=> array('NULLABLE' => false),
	        'QTD_ORIGINAL' 			=> array(),
			'DATANECESSIDADE' 		=> array('edit' => 'N'),
			'PRECO_UNITARIO' 		=> array('edit' => 'S','NULLABLE' => false),
			'PRECO_CUSTO' 			=> array('edit' => 'N','level'=>5),
			'PRECO_BASE' 			=> array('edit' => 'N'),
			'PRECO_MAXIMO' 			=> array('edit' => 'N'),
	        'PRECO_TOTAL_ITEM'		=> array('edit' => 'N'),
	        'VALOR_FRETE'			=> array(),
	        'VALOR_SEGURO'			=> array(),
			'ESTOQUE'				=> array('title' => 'ESTOQUE_REVENDA','edit' => 'N'),
			'ESTOQUE_GLOBAL' 	=> array('edit' => 'N'),
			'ESTOQUE_LOCACAO_NOVO' 	=> array('edit' => 'N'),
			'ESTOQUE_LOCACAO_USADO'	=> array('edit' => 'N'),
			'RESERVAS_LOCACAO' 		=> array('edit' => 'N','title'=>'pedidos_de_compra'),
			'RESERVAS_REVENDA' 		=> array('edit' => 'N'),
			'BAIXA' 				=> array('edit' => 'N'),
	        'UNI'					=> array('edit' => 'N'),
	        'NCM'					=> array('edit' => 'N'),
	        'STICMS'				=> array('edit' => 'N'),
	        'ORIGEM_SIT_TRIBUTARIA'	=> array('edit' => 'N'),
	        'BASE_DE_CALCULO_ICMS'	=> array('edit' => 'N'),
	        'PERCENTUAL_REDUCAO_BC_ICMS'=> array(),
	        'MODALIDADE_BC_ICMS'	=> array(),
	        'ALIQUOTA_ICMS'			=> array('edit' => 'N'),
	        'TOTAL_ICMS'			=> array('edit' => 'N'),
	        'BASE_CALCULO_ICMSST_RETIDO'=> array(),
	        'VALOR_ICMSST_RETIDO'	=> array(),
	        'BASE_DE_CALCULO_ICMS_ST'=> array('edit' => 'N'),
			'MVA_ST' 				=> array('edit' => 'N'),
			'MODALIDADE_BC_ICMSST'	=> array('edit' => 'N'),
	        'ALIQUOTA_ICMS_ST'		=> array('edit' => 'N'),
	        'TOTAL_ICMS_ST'			=> array('edit' => 'N'),
	        'STIPI'					=> array('edit' => 'N'),
	        'BASE_DE_CALCULO_IPI'	=> array('edit' => 'N'),
	        'ALIQUOTA_IPI'			=> array('edit' => 'N'),
	        'TOTAL_IPI'				=> array('edit' => 'N'),
	        'STPIS'					=> array('edit' => 'N'),
	        'BASE_DE_CALCULO_PIS'	=> array('edit' => 'N'),
	        'ALIQUOTA_PIS'			=> array('edit' => 'N'),
	        'TOTAL_PIS'				=> array('edit' => 'N'),
	        'STCOFINS'				=> array('edit' => 'N'),
	        'BASE_DE_CALCULO_COFINS'=> array('edit' => 'N'),
	        'ALIQUOTA_COFINS'		=> array('edit' => 'N'),
	        'TOTAL_COFINS'			=> array('edit' => 'N'),
	        'NUMEROS_DE_SERIE'		=> array(),
	        'NUMERO_NF'				=> array(),
			'INFORMACAO_ADICIONAL'	=> array('help'=>'help_quebrar_linha_com_;'),
			'DATA_NF'				=> array(),
			'NUM_NF_RETORNO'		=> array(),
			'DATA_RETORNO'			=> array(),
			'NUM_KIT'				=> array(),
	        'FUNC_ALTERACAO' 		=> array('edit' => 'N'),
			'DATA_ALTERACAO' 		=> array('edit' => 'N'),
			'REVISAO' 				=> array('edit' => 'N'),
			'DATASINC' 				=> array('edit' => 'N')
	);
	var $_referenceMap = array(
			'PRODUTO' => array(
					'columns' 	=> 'PRODUTO',
					'refTitle' 	=> 'DESCRICAO'
			),

			'EMPRESA' => array(
					'columns' 		=> 'EMPRESA',
					'refTableClass' => 'core_Model_DbTable_Empresa',
					'refColumns' 	=> 'CODIGO',
					'refTitle' 		=> 'NOME'
			),

	        'CFOP' => array(
	                'columns' 		=> 'CFOP',
	                'refTableClass' => 'core_Model_DbTable_Cfop',
	                'refColumns' 	=> 'CODIGO',
	                'refTitle' 		=> 'CFOP'
	        ),

			/*'STICMS' => array(
					'columns' 		=> 'STICMS',
					'refTableClass' => 'core_Model_DbTable_Sticms',
					'refColumns' 	=> 'CODIGO',
					'refTitle' 		=> 'STICMS'
			),
			'STIPI' => array(
					'columns' 		=> 'STIPI',
					'refTableClass' => 'core_Model_DbTable_Stipi',
					'refColumns' 	=> 'CODIGO',
					'refTitle' 		=> 'STIPI'
			),
			'STPIS' => array(
					'columns' 		=> 'STPIS',
					'refTableClass' => 'core_Model_DbTable_Stpis',
					'refColumns' 	=> 'CODIGO',
					'refTitle' 		=> 'STPIS'
			),
			'STCOFINS' => array(
					'columns' 		=> 'STCOFINS',
					'refTableClass' => 'core_Model_DbTable_Stpis',
					'refColumns' 	=> 'CODIGO',
					'refTitle' 		=> 'STCOFINS'
			),


			'ORIGEM_SIT_TRIBUTARIA' => array(
					'columns'           => 'ORIGEM_SIT_TRIBUTARIA',
					'refTableClass'     => 'core_Model_DbTable_Sittrib',
					'refColumns'        => 'CODIGO',
					'refTitle'          => 'CLASFISCAL'
			),*/

	);
	public function __construct()
	{
		parent::__construct();

		//$this->_restrict = "CODIGO_CLIENTE = ".$id;

		$controller      = Zend_Controller_Front::getInstance()->getRequest();
		$nome_controller = $controller->getControllerName(); //pegar a controladora
		$nome_modulo 	 = $controller->getModuleName(); //pegar o modulo


		$cliente = Zend_Registry::get('Cliente');
		if($cliente[0]['IND_COM_SERV'] == "I")
		{
			$this->_referenceMap['PRODUTO']['refTableClass'] = array('table1' => 'ind_Model_DbTable_Produto','table2' => 'ind_Model_DbTable_ProdutoCliente');
			$this->_referenceMap['PRODUTO']['refColumns'] = array('table1' => 'CODIGO','table2' => 'PRODUTO');
		}

		else if($cliente[0]['IND_COM_SERV'] == "C")
		{
			$this->_referenceMap['PRODUTO']['refTableClass'] = array('table1' => 'com_Model_DbTable_Produto','table2' => 'com_Model_DbTable_ProdutoCliente');
			$this->_referenceMap['PRODUTO']['refColumns'] = array('table1' => 'CODIGO','table2' => 'PRODUTO');
		}

		else
		{
			$this->_referenceMap['PRODUTO']['refTableClass'] = 'core_Model_DbTable_Ativoprodutos';
			$this->_referenceMap['PRODUTO']['refColumns'] = 'CODIGO';
		}


		if($nome_controller == 'programaitem' && $nome_modulo == 'especial')
		{

        	$this->_conf['PRECO_TOTAL_ITEM']['NULLABLE'] 		= false;
			
		}
	}

	public function atualizar($id1,$id2,$id3)
	{
		$sql = $this->_db->prepare('UPDATE '.$this->_name.' SET NUM_ITEM = NUM_ITEM - 1 WHERE CLIENTE='.$id1.' AND ITEM_PROGR='.$id2.' AND NUM_ITEM>'.$id3);
		$sql->execute();

	}

	public function getCfopsittrib($emp, $cfop)
	{

		$tablecfop  = new core_Model_DbTable_Cfop();
		$tableemp   = new core_Model_DbTable_Empresa();

		$table_icms				= new Cisweb_Db_Abstract("sticms");
		$table_estado			= new Cisweb_Db_Abstract("stipi");
		$table_cidade			= new Cisweb_Db_Abstract("stpis");


		$tab  		= $tablecfop->find($cfop)->current();
		$tabemp  	= $tableemp->find($emp)->current();

		if ($tabemp['REGIME_TRIBUTARIO'] == 3 || $tabemp['REGIME_TRIBUTARIO'] == 4 || $tabemp['REGIME_TRIBUTARIO'] == 13 || $tabemp['REGIME_TRIBUTARIO'] == 14)
		{

			$data['STICMS'] 	= $tab['STICMS'];
			$data['STIPI'] 		= $tab['STIPI'];
			$data['STPIS'] 		= $tab['STPIS'];
			$data['STCOFINS'] 	= $tab['STCOFINS'];

			$tabicms  	= $table_icms->find($tab['STICMS'])->current();

			if  ($tabicms['ALIQUOTA_ICMS'] == 'S')$data['ALIQUOTA_ICMS_EDIT']   = 'S';
			else $data['ALIQUOTA_ICMS_EDIT']   = 'N';

			if  ($tabicms['VALOR_BASE_CALC_ICMS'] == 'S')$data['VALOR_BASE_CALC_ICMS_EDIT']   = 'S';
			else $data['VALOR_BASE_CALC_ICMS_EDIT']   = 'N';

			if  ($tabicms['VALOR_ICMS'] == 'S')$data['VALOR_ICMS_EDIT']   = 'S';
			else $data['VALOR_ICMS_EDIT']   = 'N';
		}
		else
		{

			if (!is_null($tab['ALIQUOTA_DE_CREDITO']))
			{
				$data['ALIQUOTA_ICMS'] 	= $tab['ALIQUOTA_DE_CREDITO'];

			}
			else
			{
				$data['ALIQUOTA_ICMS'] 			= 0.0;

			}

			$data['STICMS'] 	= $tab['STICMS_SIMPLES'];
			$data['STIPI'] 		= $tab['STIPI_SIMPLES'];
			$data['STPIS'] 		= $tab['STPIS_SIMPLES'];
			$data['STCOFINS'] 	= $tab['STCOFINS_SIMPLES'];

		}

		return $data;

	}

	public function beforeInsert($data)
	{
		$controller      = Zend_Controller_Front::getInstance()->getRequest();
		$nome_controller = $controller->getControllerName(); //pegar a controladora
		$nome_modulo 	 = $controller->getModuleName();

		

		if ($nome_controller == 'programaitem' && $nome_modulo != 'especial')
		{

//			$data['PRECO_TOTAL_ITEM'] = $data['QUANTIDADE'] * $data['PRECO_UNITARIO'];

			if ($data['STICMS'] == '60')
			{
				$data['ALIQUOTA_ICMS'] 					= 0.00;
				$data['BASE_DE_CALCULO_ICMS'] 			= 0.00;
				$data['TOTAL_ICMS'] 					= 0.00;
				$data['BASE_CALCULO_ICMSST_RETIDO'] 	= 0.00;
				$data['VALOR_ICMSST_RETIDO'] 			= 0.00;

			}
			if ($data['STICMS'] == '40')
			{
				$data['ALIQUOTA_ICMS'] 					= 0.00;
				$data['BASE_DE_CALCULO_ICMS'] 			= 0.00;
				$data['TOTAL_ICMS'] 					= 0.00;

			}

			if ($data['STICMS'] == '41')
			{
				$data['ALIQUOTA_ICMS'] 					= 0.00;
				$data['BASE_DE_CALCULO_ICMS'] 			= 0.00;
				$data['TOTAL_ICMS'] 					= 0.00;

			}

			if ($data['STICMS'] == '50')
			{
				$data['ALIQUOTA_ICMS'] 					= 0.00;
				$data['BASE_DE_CALCULO_ICMS'] 			= 0.00;
				$data['TOTAL_ICMS'] 					= 0.00;

			}

			if ($data['STPIS'] == '07')
			{
				$data['ALIQUOTA_PIS'] 					= 0.00;
				$data['BASE_DE_CALCULO_PIS'] 			= 0.00;
				$data['TOTAL_PIS'] 						= 0.00;

			}

			if ($data['STCOFINS'] == '07')
			{
				$data['ALIQUOTA_COFINS'] 					= 0.00;
				$data['BASE_DE_CALCULO_COFINS'] 			= 0.00;
				$data['TOTAL_COFINS'] 						= 0.00;

			}

			if ($data['STPIS'] == '08')
			{
				$data['ALIQUOTA_PIS'] 					= 0.00;
				$data['BASE_DE_CALCULO_PIS'] 			= 0.00;
				$data['TOTAL_PIS'] 						= 0.00;

			}

			if ($data['STCOFINS'] == '08')
			{
				$data['ALIQUOTA_COFINS'] 				= 0.00;
				$data['BASE_DE_CALCULO_COFINS'] 		= 0.00;
				$data['TOTAL_COFINS'] 					= 0.00;

			}

			if ($data['NCM'] != '')
			{
				$table = new Cisweb_Db_Abstract('ncm');
				$ncm   = $table->find($data['NCM'])->current();

				$data['PERCENTUAL_REDUCAO_BC_ICMS'] 	= $ncm['ICMS_BR'];
				$data['MODALIDADE_BC_ICMS'] 			= $ncm['MODALIDADE_BC_ICMS'];

				if ($data['STICMS'] == '201' || $data['STICMS'] == '10')
				{
					$data['MODALIDADE_BC_ICMSST'] 	= $ncm['MODALIDADE_BC_ICMSST'];
					$data['MVA_ST'] 				= $ncm['ALIQUOTA_ICMS_AC'];
				}
			}
		}
		return parent::beforeInsert($data);
	}


	public function afterInsert($id)
	{

		$controller      = Zend_Controller_Front::getInstance()->getRequest();
		$nome_controller = $controller->getControllerName(); //pegar a controladora
		$nome_modulo 	 = $controller->getModuleName();


		if ($nome_controller == 'programaitem' && $nome_modulo != 'especial')
		{

			$table_progr 		= new serv_Model_DbTable_Programa();
			$table_progritem 	= new Cisweb_Db_Abstract('progritens');

			$cliente 		= $id['CLIENTE'];
			$item_progr 	= $id['ITEM_PROGR'];
			$item 	 		= $id['NUM_ITEM'];

			$dados_progr 	= $table_progr->getAdapter()->fetchAll($table_progr->select()->where("CLIENTE = '$cliente' AND ITEM = '$item_progr'"));

			$dados_item 	= $table_progritem->getAdapter()->fetchAll($table_progritem->select()->where("CLIENTE = '$cliente' AND ITEM_PROGR = '$item_progr'"));

			if (count($dados_progr) != 0);// calcula o rateio ...
			{

				$valor_frete_total 		= 0;
				$valor_seguro_total 	= 0;

				$frete 					= $dados_progr[0]['VALOR_FRETE'];
				$seguro 				= $dados_progr[0]['VALOR_SEGURO'];

				$total 					= $this->calcula_total($dados_item);

				foreach ($dados_item as $key => $value)
				{
					$valor_frete 	= 0;
					$valor_seguro 	= 0;

					if ($frete != '')
					{

						$valor_frete 		= ($frete/$total) * $value['PRECO_TOTAL_ITEM'];
						$valor_frete_total += $valor_frete;
						$dif = ($frete - $valor_frete_total);
						if ($dif < 0) $dif1 = ($dif * (-1));
						else $dif1 = $dif;
						if ($dif1 <= 0.05) $valor_frete = ($valor_frete + $dif);

						$valor_frete = number_format($valor_frete, 2 , '.' ,'');
					}


					if ($seguro != '')
					{

						$valor_seguro 		= ($seguro/$total) * $value['PRECO_TOTAL_ITEM'];
						$valor_seguro_total += $valor_seguro;
						$dif = ($seguro - $valor_seguro_total);
						if ($dif < 0) $dif1 = ($dif * (-1));
						else $dif1 = $dif;
						if ($dif1 <= 0.05) $valor_seguro = ($valor_seguro + $dif);

						$valor_seguro = number_format($valor_seguro, 2 , '.' ,'');
					}

					$data['VALOR_FRETE'] 				= $valor_frete;
					$data['VALOR_SEGURO'] 				= $valor_seguro;


					if ($frete != 0 || $seguro != 0 )
					{

						$data['BASE_DE_CALCULO_ICMS'] 		=  $value['QUANTIDADE'] * 	$value['PRECO_UNITARIO']	+ ($valor_frete + $valor_seguro);
						$data['BASE_DE_CALCULO_IPI'] 		=  $value['QUANTIDADE'] *	$value['PRECO_UNITARIO'] 	+ ($valor_frete + $valor_seguro);
						$data['BASE_DE_CALCULO_PIS'] 		=  $value['QUANTIDADE'] *	$value['PRECO_UNITARIO'] 	+ ($valor_frete + $valor_seguro);
						$data['BASE_DE_CALCULO_COFINS'] 	=  $value['QUANTIDADE'] *	$value['PRECO_UNITARIO'] 	+ ($valor_frete + $valor_seguro);

						$data['TOTAL_ICMS'] 				=  $data['BASE_DE_CALCULO_ICMS'] * ($value['ALIQUOTA_ICMS'] / 100);
						$data['TOTAL_IPI'] 					=  $data['BASE_DE_CALCULO_IPI'] * ($value['ALIQUOTA_IPI'] / 100);
						$data['TOTAL_PIS'] 					=  $data['BASE_DE_CALCULO_PIS'] * ($value['ALIQUOTA_PIS'] / 100);
						$data['TOTAL_COFINS'] 				=  $data['BASE_DE_CALCULO_COFINS'] * ($value['ALIQUOTA_COFINS'] / 100);

					}

					$iditem 		= $value['ID'];
					$whereitens 	= "ID = '$iditem'";
					$table_progritem->update($data,$whereitens);

				}
			}
			
			/*Prepara o estoque de reserva*/
			$table_estoque_reserva = new Cisweb_Db_Abstract('estoque_reserva');
			$table_config		   = new Cisweb_Db_Abstract('config');	
			$table_progr		   = new Cisweb_Db_Abstract('progr');	
			
			$dados_progr 		   = $table_progr->select()->where("CLIENTE = ?", $id['CLIENTE'])->where("ITEM = ?", $id['ITEM_PROGR']);
			$dados_progr		   = $table_progr->fetchAll($dados_progr)->toArray();
			$id_progr			   = $dados_progr[0]['ID'];
			$numero_progr   	   = $dados_progr[0]['CLIENTE'].'/'.$dados_progr[0]['ITEM'];
			
			$dados_item 		   = $this->select()->where("CLIENTE = ?", $id['CLIENTE'])->where("ITEM_PROGR = ?", $id['ITEM_PROGR'])->where("NUM_ITEM = ?", $id['NUM_ITEM']);
			$dados_item			   = $this->fetchAll($dados_item)->toArray();
			
			$dados_config		   = $table_config->fetchRow()->toArray();
			$dias_queda_reserva    = (int)$dados_config['DIAS_QUEDA_RESERVA'];
			$data_queda_reserva	   = mktime(0,0,0,date('m'), date('d') + $dias_queda_reserva, date('Y'));
			
			$data_reserva['EMPRESA'] 	   = $dados_item[0]['EMPRESA'];
			$data_reserva['ID_ITEM'] 	   = $dados_item[0]['ID'];
			$data_reserva['ID_PROGR'] 	   = $id_progr;
			$data_reserva['NUMERO_PROGR']  = $numero_progr;
			$data_reserva['PRODUTO'] 	   = $dados_item[0]['PRODUTO'];
			$data_reserva['QUANTIDADE']    = $dados_item[0]['QUANTIDADE'];
			$data_reserva['DATA_EXPIRAR']  = date('Y-m-d', $data_queda_reserva);
			
			$table_estoque_reserva->insert($data_reserva);
		}
	}


	public function calcula_total($dados_item)
	{
		$total = 0;

		foreach ($dados_item as $key => $value)
		{
				$total 		+= $value['PRECO_TOTAL_ITEM'];
		}

		return $total;
	}


	public function beforeUpdate($data, $where)
	{
		$controller      = Zend_Controller_Front::getInstance()->getRequest();
		$nome_controller = $controller->getControllerName(); //pegar a controladora
		$nome_modulo 	 = $controller->getModuleName();

		/*if ($nome_controller == 'nfecis' && $nome_controller == 'impressaopedidocliente')
		{
			$cliente 		= $where[' CLIENTE = ? '];
			$item_progr 	= $where[' ITEM_PROGR = ? '];

			$this->Voltar_Para_Kit($cliente,$item_progr);
			die();
		}	*/
		
		if ($nome_controller == 'programaitem' && $nome_modulo != 'especial')
		{
//			$data['PRECO_TOTAL_ITEM'] = $data['QUANTIDADE'] * $data['PRECO_UNITARIO'];

			if ($data['STICMS'] == '40')
			{
				$data['ALIQUOTA_ICMS'] 					= 0.00;
				$data['BASE_DE_CALCULO_ICMS'] 			= 0.00;
				$data['TOTAL_ICMS'] 					= 0.00;

			}

			if ($data['STICMS'] == '41')
			{
				$data['ALIQUOTA_ICMS'] 					= 0.00;
				$data['BASE_DE_CALCULO_ICMS'] 			= 0.00;
				$data['TOTAL_ICMS'] 					= 0.00;

			}

			if ($data['STICMS'] == '50')
			{
				$data['ALIQUOTA_ICMS'] 					= 0.00;
				$data['BASE_DE_CALCULO_ICMS'] 			= 0.00;
				$data['TOTAL_ICMS'] 					= 0.00;

			}

			if ($data['STICMS'] == '60')
			{
				$data['ALIQUOTA_ICMS'] 					= 0.00;
				$data['BASE_DE_CALCULO_ICMS'] 			= 0.00;
				$data['TOTAL_ICMS'] 					= 0.00;
				$data['BASE_CALCULO_ICMSST_RETIDO'] 	= 0.00;
				$data['VALOR_ICMSST_RETIDO'] 			= 0.00;

			}

			if ($data['STPIS'] == '07')
			{
				$data['ALIQUOTA_PIS'] 					= 0.00;
				$data['BASE_DE_CALCULO_PIS'] 			= 0.00;
				$data['TOTAL_PIS'] 						= 0.00;

			}

			if ($data['STCOFINS'] == '07')
			{
				$data['ALIQUOTA_COFINS'] 					= 0.00;
				$data['BASE_DE_CALCULO_COFINS'] 			= 0.00;
				$data['TOTAL_COFINS'] 						= 0.00;

			}

			if ($data['STPIS'] == '08')
			{
				$data['ALIQUOTA_PIS'] 					= 0.00;
				$data['BASE_DE_CALCULO_PIS'] 			= 0.00;
				$data['TOTAL_PIS'] 						= 0.00;

			}

			if ($data['STCOFINS'] == '08')
			{
				$data['ALIQUOTA_COFINS'] 				= 0.00;
				$data['BASE_DE_CALCULO_COFINS'] 		= 0.00;
				$data['TOTAL_COFINS'] 					= 0.00;

			}

			if ($data['STICMS'] == '00' && $data['BASE_DE_CALCULO_ICMS'] == '00.0')
			{
				$data['BASE_DE_CALCULO_ICMS'] 			= $data['PRECO_TOTAL_ITEM'];
			}

			if (isset($data['NCM']) && $data['NCM'] != '')
			{
				$table = new Cisweb_Db_Abstract('ncm');
				$ncm   = $table->find($data['NCM'])->current();

				$data['PERCENTUAL_REDUCAO_BC_ICMS'] 	= $ncm['ICMS_BR'];
				$data['MODALIDADE_BC_ICMS'] 			= $ncm['MODALIDADE_BC_ICMS'];

				if ($data['STICMS'] == '201' || $data['STICMS'] == '10')
				{
					$data['MODALIDADE_BC_ICMSST'] 	= $ncm['MODALIDADE_BC_ICMSST'];
					$data['MVA_ST'] 				= $ncm['ALIQUOTA_ICMS_AC'];
				}
			}
		}

		return parent::beforeUpdate($data, $where);

	}

	public function afterUpdate($id,$where)
	{

		$controller      = Zend_Controller_Front::getInstance()->getRequest();
		$nome_controller = $controller->getControllerName(); //pegar a controladora
		$nome_modulo 	 = $controller->getModuleName();

		
		if ($nome_controller == 'programaitem' && $nome_modulo != 'especial')
		{

			$table_progr 		= new serv_Model_DbTable_Programa();
			$table_progritem 	= new Cisweb_Db_Abstract('progritens');

			$cliente 		= $where[' CLIENTE = ? '];
			$item_progr 	= $where[' ITEM_PROGR = ? '];
			$item 	 		= $where[' NUM_ITEM = ? '];

			$dados_progr 	= $table_progr->getAdapter()->fetchAll($table_progr->select()->where("CLIENTE = '$cliente' AND ITEM = '$item_progr'"));


			$dados_item 	= $table_progritem->getAdapter()->fetchAll($table_progritem->select()->where("CLIENTE = '$cliente' AND ITEM_PROGR = '$item_progr'"));

			if (count($dados_progr) != 0);// calcula o rateio ...
			{

				$valor_frete_total 		= 0;
				$valor_seguro_total 	= 0;

				$frete 					= $dados_progr[0]['VALOR_FRETE'];
				$seguro 				= $dados_progr[0]['VALOR_SEGURO'];

				$total 					= $this->calcula_total($dados_item);

				foreach ($dados_item as $key => $value)
				{
					$valor_frete 	= 0;
					$valor_seguro 	= 0;

					if ($frete != '')
					{

						$valor_frete 		= ($frete/$total) * $value['PRECO_TOTAL_ITEM'];
						$valor_frete_total += $valor_frete;
						$dif = ($frete - $valor_frete_total);
						if ($dif < 0) $dif1 = ($dif * (-1));
						else $dif1 = $dif;
						if ($dif1 <= 0.05) $valor_frete = ($valor_frete + $dif);

						$valor_frete = number_format($valor_frete, 2 , '.' ,'');
					}


					if ($seguro != '')
					{

						$valor_seguro 		= ($seguro/$total) * $value['PRECO_TOTAL_ITEM'];
						$valor_seguro_total += $valor_seguro;
						$dif = ($seguro - $valor_seguro_total);
						if ($dif < 0) $dif1 = ($dif * (-1));
						else $dif1 = $dif;
						if ($dif1 <= 0.05) $valor_seguro = ($valor_seguro + $dif);

						$valor_seguro = number_format($valor_seguro, 2 , '.' ,'');
					}

					$data['VALOR_FRETE'] 				= $valor_frete;
					$data['VALOR_SEGURO'] 				= $valor_seguro;

					if ($frete != 0 || $seguro != 0 )
					{
						$data['BASE_DE_CALCULO_ICMS'] 		=  $value['QUANTIDADE'] * 	$value['PRECO_UNITARIO']	+ ($valor_frete + $valor_seguro);
						$data['BASE_DE_CALCULO_IPI'] 		=  $value['QUANTIDADE'] *	$value['PRECO_UNITARIO'] 	+ ($valor_frete + $valor_seguro);
						$data['BASE_DE_CALCULO_PIS'] 		=  $value['QUANTIDADE'] *	$value['PRECO_UNITARIO'] 	+ ($valor_frete + $valor_seguro);
						$data['BASE_DE_CALCULO_COFINS'] 	=  $value['QUANTIDADE'] *	$value['PRECO_UNITARIO'] 	+ ($valor_frete + $valor_seguro);

						$data['TOTAL_ICMS'] 				=  $data['BASE_DE_CALCULO_ICMS'] * ($value['ALIQUOTA_ICMS'] / 100);
						$data['TOTAL_IPI'] 					=  $data['BASE_DE_CALCULO_IPI'] * ($value['ALIQUOTA_IPI'] / 100);
						$data['TOTAL_PIS'] 					=  $data['BASE_DE_CALCULO_PIS'] * ($value['ALIQUOTA_PIS'] / 100);
						$data['TOTAL_COFINS'] 				=  $data['BASE_DE_CALCULO_COFINS'] * ($value['ALIQUOTA_COFINS'] / 100);
					}

					$iditem 		= $value['ID'];
					$whereitens 	= "ID = '$iditem'";
					$table_progritem->update($data,$whereitens);

				}

			}

		}
	}


	public function beforeDelete($where)
	{

		$controller      = Zend_Controller_Front::getInstance()->getRequest();
		$nome_controller = $controller->getControllerName(); //pegar a controladora
		$nome_modulo 	 = $controller->getModuleName();


		if ($nome_controller == 'programaitem' && $nome_modulo != 'especial')
		{

			$table_progr 		= new serv_Model_DbTable_Programa();
			$table_progritem 	= new Cisweb_Db_Abstract('progritens');

			$cliente 			= $where[' CLIENTE = ? '];
			$item_progr 		= $where[' ITEM_PROGR = ? '];
			$item 	 			= $where[' NUM_ITEM = ? '];

			$dados_progr 		= $table_progr->getAdapter()->fetchAll($table_progr->select()->where("CLIENTE = '$cliente' AND ITEM = '$item_progr'"));

			$dados_item 		= $this->getAdapter()->fetchAll($this->select()->where("CLIENTE = '$cliente' AND ITEM_PROGR = '$item_progr' AND NUM_ITEM <> '$item'"));

			if (count($dados_progr) != 0);// calcula o rateio ...
			{

				$valor_frete_total 		= 0;
				$valor_seguro_total 	= 0;

				$frete 					= $dados_progr[0]['VALOR_FRETE'];
				$seguro 				= $dados_progr[0]['VALOR_SEGURO'];

				$total 					= $this->calcula_total($dados_item);

				foreach ($dados_item as $key => $value)
				{
					$valor_frete 	= 0;
					$valor_seguro 	= 0;

					if ($frete != '')
					{

						$valor_frete 		= ($frete/$total) * $value['PRECO_TOTAL_ITEM'];
						$valor_frete_total += $valor_frete;
						$dif = ($frete - $valor_frete_total);
						if ($dif < 0) $dif1 = ($dif * (-1));
						else $dif1 = $dif;
						if ($dif1 <= 0.05) $valor_frete = ($valor_frete + $dif);

						$valor_frete = number_format($valor_frete, 2 , '.' ,'');
					}

					if ($seguro != '')
					{

						$valor_seguro 		= ($seguro/$total) * $value['PRECO_TOTAL_ITEM'];
						$valor_seguro_total += $valor_seguro;
						$dif = ($seguro - $valor_seguro_total);
						if ($dif < 0) $dif1 = ($dif * (-1));
						else $dif1 = $dif;
						if ($dif1 <= 0.05) $valor_seguro = ($valor_seguro + $dif);

						$valor_seguro = number_format($valor_seguro, 2 , '.' ,'');
					}

					$data['VALOR_FRETE'] 				= $valor_frete;
					$data['VALOR_SEGURO'] 				= $valor_seguro;

					$data['BASE_DE_CALCULO_ICMS'] 		=  $value['QUANTIDADE'] * 	$value['PRECO_UNITARIO']	+ ($valor_frete + $valor_seguro);
					$data['BASE_DE_CALCULO_IPI'] 		=  $value['QUANTIDADE'] * 	$value['PRECO_UNITARIO']	+ ($valor_frete + $valor_seguro);
					$data['BASE_DE_CALCULO_PIS'] 		=  $value['QUANTIDADE'] * 	$value['PRECO_UNITARIO']	+ ($valor_frete + $valor_seguro);
					$data['BASE_DE_CALCULO_COFINS'] 	=  $value['QUANTIDADE'] * 	$value['PRECO_UNITARIO']	+ ($valor_frete + $valor_seguro);

					$iditem 		= $value['ID'];
					$whereitens 	= "ID = '$iditem'";
					$table_progritem->update($data,$whereitens);

				}

			}

		}

		return parent::beforeDelete($where);
	}
	
	public function getAliquotas($cliente,$empresa)
	{
	
		$table_estado 		= new core_Model_DbTable_Estado();
		$table_ncm 			= new core_Model_DbTable_Ncm();
		$table_empresa 		= new core_Model_DbTable_Empresa();
		$table_ativos 		= new core_Model_DbTable_Ativoprodutos();
		$table_cidade 		= new core_Model_DbTable_Cidade();
		$table_fornecedor 	= new serv_Model_DbTable_Fornecedor();
		$table_ncmst 		= new core_Model_DbTable_Ncmst();
		$table_cliente		= new serv_Model_DbTable_Cliente();
	
		/*$where 					= "CLIENTE = '$cliente' AND NUM_ITEM = '$item'";
			$campos					= $this->getAdapter()->fetchRow($this->select()->where(($where)));*/
	
		//Dados da empresa
		$camposemp 				= $table_empresa->find($empresa)->current();
		$camposcityemp 			= $table_cidade->find($camposemp['CIDADE'])->current();
		$camposestadoempresa	= $table_estado->find($camposcityemp['UF'])->current();
	
		//Dados do cliente
		$camposcli 				= $table_cliente->find($cliente)->current();
		$camposcitycli 			= $table_cidade->find($camposcli['CIDADE'])->current();
		$camposestadocliente	= $table_estado->find($camposcitycli['UF'])->current();
	
		$aliquota_icms 			= $camposestadoempresa["ICMS_{$camposestadocliente['UF']}"];
	
		$aliquota_icms_st 		= $camposestadoempresa["ICMS_{$camposestadoempresa['UF']}"];
		$arr['ALIQUOTA_ICMS_ST']= $aliquota_icms_st;
		$arr['ALIQUOTA_ICMS'] 	= $aliquota_icms;
		$arr['ALIQUOTA_PIS'] 	= $camposemp['PIS'];
		$arr['ALIQUOTA_COFINS'] = $camposemp['COFINS'];
			
		if (!isset($campos2['ALIQUOTA_COFINS'])) $arr['COFINS'] 			= $camposemp['COFINS'];
	
		return $arr;
	}
	
	
	public function BuscaImpostos($dados)
	{


	
		$tablecfop  			= new core_Model_DbTable_Cfop();
		$tableemp   			= new core_Model_DbTable_Empresa();
		$table_icms				= new Cisweb_Db_Abstract("sticms");
		$table_ipi				= new Cisweb_Db_Abstract("stipi");
		$table_pis				= new Cisweb_Db_Abstract("stpis");
	
		$aliquota = $this->getAliquotas($dados['CLIENTE'], $dados['EMPRESA']);
		
		$data = array();
	
		if ($dados['EMPRESA'] != '')
		{
			$tabemp  	= $tableemp->find($dados['EMPRESA'])->current();
		}
		
		if ($dados['CFOP'] != '')
		{
			
			$tabcfop  	= $tablecfop->find($dados['CFOP'])->current();

				
			if ($tabemp['REGIME_TRIBUTARIO'] == 3 || $tabemp['REGIME_TRIBUTARIO'] == 4 || $tabemp['REGIME_TRIBUTARIO'] == 13 || $tabemp['REGIME_TRIBUTARIO'] == 14)
			{
				$data['STICMS'] 	= $tabcfop['STICMS'];
				$data['STIPI'] 		= $tabcfop['STIPI'];
				$data['STPIS'] 		= $tabcfop['STPIS'];
				$data['STCOFINS'] 	= $tabcfop['STCOFINS'];
					
				// operacoes com ICMS
				if ($tabcfop['STICMS'] != '')
				{
					$tabicms  	= $table_icms->find($tabcfop['STICMS'])->current();
	
					// CALCULO ICMS
					if  ($tabicms['ALIQUOTA_ICMS'] == 'N')
					{
						$data['ALIQUOTA_ICMS'] 					= 0.00;
					}
					if  ($tabicms['VALOR_BASE_CALC_ICMS'] == 'N')
					{
						$data['BASE_DE_CALCULO_ICMS'] 			= 0.00;
					}
						
					// CALCULO ICMS ST
						
					if  ($tabicms['VALOR_ICMS_ST'] == 'N' && $tabicms['VALOR_BASE_ICMS_ST'] == 'N')
					{
						$data['BASE_DE_CALCULO_ICMS_ST'] = 0.00;
						$data['TOTAL_ICMS_ST'] = 0.00;
					}
				}
	
				//operacao com pis
	
				if ($tabcfop['STPIS'] != '')
				{
					$tabpis  	= $table_pis->find($tabcfop['STPIS'])->current();
	
					// CALCULO PIS
					if  ($tabpis['ALIQUOTA_PORCENTO'] == 'N')
					{
						$data['ALIQUOTA_PIS'] 					= 0.00;
					}
					// CALCULO PIS
					elseif  ($tabpis['ALIQUOTA_PORCENTO'] == 'S')
					{
						$data['ALIQUOTA_PIS'] 					= $aliquota['ALIQUOTA_PIS'];
					}
						
					if  ($tabpis['BASE_CALC_REAIS'] == 'N')
					{
						$data['BASE_DE_CALCULO_PIS'] 			= 0.00;
					}
					
					if  ($tabpis['VALOR_PIS_COFINS'] == 'N')
					{
						$data['TOTAL_PIS'] 					= 0.00;
					}
					elseif  ($tabpis['VALOR_PIS_COFINS'] == 'S' && isset($dados['BASE_DE_CALCULO_PIS']))
					{
						$data['TOTAL_PIS'] = $dados['BASE_DE_CALCULO_PIS'] * ($data['ALIQUOTA_PIS'] / 100);
					}
				}
	
				//operacao com COFINS
	
				if ($tabcfop['STCOFINS'] != '')
				{
					$tabpis  	= $table_pis->find($tabcfop['STCOFINS'])->current();
	
					// CALCULO PIS
					if  ($tabpis['ALIQUOTA_PORCENTO'] == 'N')
					{
						$data['ALIQUOTA_COFINS'] 					= 0.00;
					}
					elseif($tabpis['ALIQUOTA_PORCENTO'] == 'S')
					{
						$data['ALIQUOTA_COFINS'] 					= $aliquota['ALIQUOTA_COFINS'];
					}
	
					if  ($tabpis['BASE_CALC_REAIS'] == 'N')
					{
						$data['BASE_DE_CALCULO_COFINS'] 			= 0.00;
					}
					
					if  ($tabpis['VALOR_PIS_COFINS'] == 'N')
					{
						$data['TOTAL_COFINS'] 						= 0.00;
					}
					elseif  ($tabpis['VALOR_PIS_COFINS'] == 'S' && isset($dados['BASE_DE_CALCULO_COFINS']))
					{
						$data['TOTAL_COFINS'] = $dados['BASE_DE_CALCULO_COFINS'] * ($data['ALIQUOTA_COFINS'] / 100);
					}
				}
	
				//operacao com IPI
	
				if ($tabemp['REGIME_TRIBUTARIO'] == 3 || $tabemp['REGIME_TRIBUTARIO'] == 4 && $dados['ORIGEM_SIT_TRIBUTARIA'] == 1)
				{
					
					if ($tabcfop['STIPI'] != '')
					{
						$tabipi  	= $table_ipi->find($tabcfop['STIPI'])->current();
	
						// CALCULO PIS
						if  ($tabipi['ALIQUOTA_IPI'] == 'N')
						{
							$data['ALIQUOTA_IPI'] 					= 0;
						}
						elseif ($dados['NCM'] != '')
						{
							$ncm 		= $this->getNcm($dados['NCM']);
								
							// CALCULO PIS
							if  ($dados['ALIQUOTA_IPI'] == '')
							{
								$data['ALIQUOTA_IPI'] 					= $ncm['IPI'];
							}
						}
	
						if  ($tabipi['VALOR_BASE_CALC_IPI'] == 'N')
						{
							$data['BASE_DE_CALCULO_IPI'] 			= 0.00;
						}
						if  ($tabipi['VALOR_IPI'] == 'N')
						{
							$data['TOTAL_IPI'] 						= 0.00;
						}
					}// fim do ipi
				}
			}// fim regime nomal
			
			else{ //regime simples

				$data['STICMS'] 	= $tabcfop['STICMS_SIMPLES'];
				$data['STIPI'] 		= $tabcfop['STIPI_SIMPLES'];
				$data['STPIS'] 		= $tabcfop['STPIS_SIMPLES'];
				$data['STCOFINS'] 	= $tabcfop['STCOFINS_SIMPLES'];
					
				// operacoes com ICMS
				if ($tabcfop['STICMS_SIMPLES'] != ''){
					
					// CALCULO ICMS
					$data['ALIQUOTA_ICMS'] 					= 0.00;
					$data['BASE_DE_CALCULO_ICMS'] 			= 0.00;
					$data['TOTAL_ICMS'] 					= 0.00;

					// Credito ICMS

					if ($tabcfop['ALIQUOTA_DE_CREDITO'] != ''){
						
						$data['ALIQUOTA_ICMS'] 					= $tabcfop['ALIQUOTA_DE_CREDITO'];
						$data['BASE_DE_CALCULO_ICMS'] 			= $dados['QUANTIDADE'] * $dados['PRECO_UNITARIO'];
						$data['TOTAL_ICMS'] 					= $data['BASE_DE_CALCULO_ICMS'] * ($tabcfop['ALIQUOTA_DE_CREDITO'] /100);
					}
					
				}

				// CALCULO ICMS ST
				$data['BASE_DE_CALCULO_ICMS_ST'] 		= 0.00;
				$data['TOTAL_ICMS_ST'] 					= 0.00;
	
				//operacao com pis
	
				
				$data['ALIQUOTA_PIS'] 					= 0.00;
				$data['BASE_DE_CALCULO_PIS'] 			= 0.00;
				$data['TOTAL_PIS'] 						= 0.00;
			
	
				//operacao com COFINS
	
				
				$data['ALIQUOTA_COFINS'] 				= 0.00;
				$data['BASE_DE_CALCULO_COFINS'] 		= 0.00;
				$data['TOTAL_COFINS'] 					= 0.00;
				
	
				//operacao com IPI
	
				$data['ALIQUOTA_IPI'] 					= 0;
				$data['BASE_DE_CALCULO_IPI'] 			= 0.00;
				$data['TOTAL_IPI'] 						= 0.00;
						
			}
		}

		return $data;
	
	}
	
	public function getNcm($ncm)
	{
		$table				= new Cisweb_Db_Abstract("ncm");
		return $campos 			= $table->find($ncm)->current()->toArray();
	
	}


	public function getEmpresa($emp)
	{

		$table = new core_Model_DbTable_Empresa();
		$dados = $table->find($emp)->toArray();

		return $dados[0];
	}

	public function Buscapreco($prod,$cli,$tipo)
	{
		if ($tipo == 'L')
		{

			$table = new core_Model_DbTable_Ativoprodutos();
			$dados = $table->find($prod);
			return $dados;

		}
		elseif ($tipo == 'P')
		{
			$table = new core_Model_DbTable_Produtocliente();
			$dados = $table->findMultipleKey(array($prod,$cli));
			return $dados;
		}
		
		elseif ($tipo == 'A')
		{
			$table = new core_Model_DbTable_Produtocliente();
			$dados = $table->findMultipleKey(array($prod,$cli));
			
			if (count($dados) != 0)
			{
				return 'P';
			}	
			
			$table = new core_Model_DbTable_Ativoprodutos();
			$dados = $table->find($prod);
			
			if (count($dados) != 0)
			{
				if ($dados[0]['PRECO_LISTA'] != '')
				return 'L';
			}
			
			return 'R';
		}
	}
	
	public function historico_item($prod)
	{
		$dados 			= $this->getAdapter()->fetchAll($this->select()->where("PRODUTO = '$prod' and NUMERO_NF is not null")->order("DATA_NF DESC")->limit(20));
		
		return $dados;
	}

	public function historico_itemcliente($prod,$cli){
		$dadoscomcli 	= $this->getAdapter()->fetchAll($this->select()->where("CLIENTE = '$cli' and PRODUTO = '$prod' and NUMERO_NF is not null")->order("DATA_NF DESC")->limit(20));
	
		return $dadoscomcli;
	}

	public function Voltar_Para_Kit($cliente,$item_progr){

		$itens_pedido 	= $this->getAdapter()->fetchAll($this->select()
			->from($this, array('*','sum(PRECO_TOTAL_ITEM) as TOTAL_KIT'))
			->where("CLIENTE = '$cliente' AND ITEM_PROGR = '$item_progr'")
			->group("NUM_KIT"));

    	$array_kit = array();

    	foreach ($itens_pedido as $k => $v) {
    		
    		//$dados_prod = $this->BuscaProduto($v['PRODUTO']);
    		if ($v['NUM_KIT'] != ''){	

    			$array_kit['CLIENTE'] 			= $v['CLIENTE'];
				$array_kit['ITEM_PROGR'] 		= $v['ITEM_PROGR'];
				$array_kit['NUM_ITEM'] 			= $v['NUM_ITEM'];
				$array_kit['EMPRESA'] 			= $v['EMPRESA'];
			
				$array_kit['CFOP'] 				= $v['CFOP'];
				$array_kit['PRODUTO'] 			= $v['NUM_KIT'];
				$array_kit['QUANTIDADE'] 		= 1;
				$array_kit['PRECO_UNITARIO'] 	= $v['TOTAL_KIT'];
				$array_kit['PRECO_TOTAL_ITEM'] 	= $v['TOTAL_KIT'];
				$array_kit['NUM_KIT'] 			= null;				
				
				$id 		= $v['NUM_KIT'];	
				$where_i 	= "NUM_KIT = '$id'";

				$this->delete($where_i);

				$this->atualizar($v['CLIENTE'],$v['ITEM_PROGR'],$v['NUM_ITEM']);

				$select = $this->fetchRow($this->select()
                    ->from('progritens', array('MAX(NUM_ITEM) AS NUM_ITEM'))
                    ->where('CLIENTE=?', $cliente)->where('ITEM_PROGR=?', $item_progr));
			
				$array_kit['NUM_ITEM'] = $select['NUM_ITEM'] + 1;
			
				$this->insert($array_kit);
			}
    	}
	}

	public function Remonta_Itens($where){
    	
    	
    	$itens_pedido 	= $this->getAdapter()->fetchAll($this->select()->where($where));

    	$array_kit = array();

    	foreach ($itens_pedido as $k => $v) {
    		
    		$dados_prod = $this->BuscaProduto($v['PRODUTO']);

    		// verifica se e kit
    		if ($dados_prod[0]['TIPO'] == 'K'){
    			
    			$itens_kit = $this->BuscaKit($v['PRODUTO']);
				
				if (count($itens_kit) == 0){
					echo 'Falta produtos no Kit';
					die();
				}
				else{

					$array_kit = $this->Monta_Itens_Kit($itens_kit,$v);						
				} 

				$id 		= $v['ID'];	
				$where_i 	= "ID = '$id'";

				$this->delete($where_i);

				$this->atualizar($v['CLIENTE'],$v['ITEM_PROGR'],$v['NUM_ITEM']);

				$this->Inserir_Itens_Kit($array_kit);

    		}	
    	}
    }



    public function Inserir_Itens_Kit($itens_kit){

    	foreach ($itens_kit as $key => $value) {

			$select = $this->fetchRow($this->select()
                    ->from('progritens', array('MAX(NUM_ITEM) AS NUM_ITEM'))
                    ->where('CLIENTE=?', $value['CLIENTE'])->where('ITEM_PROGR=?', $value['ITEM_PROGR']));
			
			$value['NUM_ITEM'] = $select['NUM_ITEM'] + 1;
			
			$this->insert($value);
    	}
    }

    public function Monta_Itens_Kit($itens_kit,$kit){

    	$total_PROP = 0;

    	foreach ($itens_kit as $key => $value) {
			$total_PROP += $value['PROPORCAO_PRECO'];
    	}

    	foreach ($itens_kit as $key => $value) {
		
			$porcentagem = $value['PROPORCAO_PRECO']/$total_PROP;

			$preco = $kit['PRECO_TOTAL_ITEM'] * $porcentagem;

			$array_kit[$key]['CLIENTE'] 			= $kit['CLIENTE'];
			$array_kit[$key]['ITEM_PROGR'] 			= $kit['ITEM_PROGR'];
			$array_kit[$key]['NUM_ITEM'] 			= $kit['NUM_ITEM'];
			$array_kit[$key]['EMPRESA'] 			= $kit['EMPRESA'];
			
			$array_kit[$key]['CFOP'] 				= $kit['CFOP'];
			$array_kit[$key]['PRODUTO'] 			= $value['COMP'];
			$array_kit[$key]['QUANTIDADE'] 			= $value['QTD_COMP'];
			$array_kit[$key]['PRECO_UNITARIO'] 	 	= $preco/$value['QTD_COMP'];
			$array_kit[$key]['PRECO_TOTAL_ITEM'] 	= $preco;
			$array_kit[$key]['NUM_KIT'] 			= $value['PRODUTO'];
 		}

 		return $array_kit;
    }


    public function Volta_Monta_Itens_Kit($itens_kit,$kit){

    	$total_PROP = 0;

    	foreach ($itens_kit as $key => $value) {
			$total_PROP += $value['PROPORCAO_PRECO'];
    	}

    	foreach ($itens_kit as $key => $value) {
		
			$porcentagem = $value['PROPORCAO_PRECO']/$total_PROP;

			$preco = $kit['PRECO_TOTAL_ITEM'] * $porcentagem;

			$array_kit[$key]['CLIENTE'] 			= $kit['CLIENTE'];
			$array_kit[$key]['ITEM_PROGR'] 			= $kit['ITEM_PROGR'];
			$array_kit[$key]['NUM_ITEM'] 			= $kit['NUM_ITEM'];
			$array_kit[$key]['EMPRESA'] 			= $kit['EMPRESA'];
			
			$array_kit[$key]['CFOP'] 				= $kit['CFOP'];
			$array_kit[$key]['PRODUTO'] 			= $value['COMP'];
			$array_kit[$key]['QUANTIDADE'] 			= $value['QTD_COMP'];
			$array_kit[$key]['PRECO_UNITARIO'] 	 	= $preco/$value['QTD_COMP'];
			$array_kit[$key]['PRECO_TOTAL_ITEM'] 	= $preco;
			$array_kit[$key]['NUM_KIT'] 			= $value['PRODUTO'];
 		}

 		return $array_kit;
    }


    public function BuscaProduto($prod){

    	$produto 	= new Cisweb_Db_Abstract('produtos');
		return $dados 		= $produto->find($prod);
		
    }

     public function BuscaKit($prod){

    	$kit 			= new Cisweb_Db_Abstract('produtokititens');
    	$itens			= $kit->getAdapter()->fetchAll($kit->select()->where("PRODUTO = '$prod'"));
		return $itens;
		
    }

    public function Verifica_Itens_Pedido($id){

    	$cliente = $id['CLIENTE'];
    	$item = $id['ITEM'];
    	$where = "CLIENTE = '$cliente' AND ITEM_PROGR = '$item'";	
    	$itens_pedido 	= $this->getAdapter()->fetchAll($this->select()->where($where));

    	foreach ($itens_pedido as $key => $value) {


    		 $produto = $this->BuscaProduto($value['PRODUTO']); 

    		 $impostos = $this->BuscaImpostos($value);

    		 //$data['VALOR_FRETE'] 					=
    		 //$data['VALOR_SEGURO'] 					= 
    		 
    		 $data['UNI'] 							= $produto[0]['UNIDADE'];
    		 $data['NCM'] 							= $produto[0]['CLASFISCAL'];
    		 $data['ORIGEM_SIT_TRIBUTARIA'] 		= $produto[0]['ORIGEM_SIT_TRIBUTARIA'];
    		 
    		 $data['STICMS'] 						= $impostos['STICMS'];

    		 $data['ALIQUOTA_ICMS'] 				= $impostos['ALIQUOTA_ICMS'];
    		 $data['BASE_DE_CALCULO_ICMS'] 			= $impostos['BASE_DE_CALCULO_ICMS'];
    		 $data['TOTAL_ICMS'] 					= $impostos['TOTAL_ICMS'];
    		 
    		 //$data['PERCENTUAL_REDUCAO_BC_ICMS'] 	= $impostos[''];
    		 //$data['MODALIDADE_BC_ICMS'] => 3 
    		 //$data['BASE_CALCULO_ICMSST_RETIDO'] 	= $impostos[''];
    		 //$data['VALOR_ICMSST_RETIDO'] 			= $impostos[''];
    		 
    		 $data['BASE_DE_CALCULO_ICMS_ST'] 		= $impostos['BASE_DE_CALCULO_ICMS_ST'];
    		 //$data['MVA_ST'] 						= $impostos[''];
    		 //$data['MODALIDADE_BC_ICMSST'] 			= $impostos[''];
    		 //$data['ALIQUOTA_ICMS_ST'] 				= $impostos[''];
    		 //$data['TOTAL_ICMS_ST'] 				= $impostos['TOTAL_ICMS_ST'];
    		 
    		 $data['STIPI'] 						= $impostos['STIPI'];
    		 $data['BASE_DE_CALCULO_IPI'] 			= $impostos['BASE_DE_CALCULO_IPI'];
    		 $data['ALIQUOTA_IPI'] 					= $impostos['ALIQUOTA_IPI'];
    		 $data['TOTAL_IPI'] 					= $impostos['TOTAL_IPI'];
    		 
    		 $data['STPIS'] 						= $impostos['STPIS'];
    		 $data['BASE_DE_CALCULO_PIS'] 			= $impostos['BASE_DE_CALCULO_PIS'];
    		 $data['ALIQUOTA_PIS'] 					= $impostos['ALIQUOTA_PIS'];
    		 $data['TOTAL_PIS'] 					= $impostos['TOTAL_PIS'];
    		 
    		 $data['STCOFINS'] 						= $impostos['STCOFINS'];
    		 $data['BASE_DE_CALCULO_COFINS'] 		= $impostos['BASE_DE_CALCULO_COFINS'];
    		 $data['ALIQUOTA_COFINS'] 				= $impostos['ALIQUOTA_COFINS'];
    		 $data['TOTAL_COFINS'] 					= $impostos['TOTAL_COFINS'];

    		 $id_item = $value['ID'];	
    		 
    		 $this->update($data,"ID = '$id_item'");
    	}


    }
}
?>